<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis bodů výškového řešení XY</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis bodů výškového řešení XY</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br />
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <xsl:for-each select="HorizontalAlignment[VerticalAlignment]">
                                    <table class="margin" width="90%">
                                        <thead>
                                            <tr>
                                                <th align="right" colspan="2" lang="en"><br/>Směrové řešení:</th>
                                                <td align="left" colspan="4" valign="bottom"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Popis:</th>
                                                <td align="left" colspan="4"><xsl:value-of select="@description"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Styl:</th>
                                                <td align="left" colspan="4"><xsl:value-of select="@style"/></td>
                                            </tr>
                                            <tr>
                                                <th colspan="6">&#xa0;</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <xsl:for-each select="VerticalAlignment">
                                                <tr>
                                                    <th align="right" colspan="2" lang="en"><br/>Výškové řešení:</th>
                                                    <td align="left" colspan="4" valign="bottom"><xsl:value-of select="@name"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" colspan="2" lang="en">Popis:</th>
                                                    <td align="left" colspan="4"><xsl:value-of select="@description"/></td>
                                                </tr>
                                                <tr>
                                                    <th align="right" colspan="2" lang="en">Styl:</th>
                                                    <td align="left" colspan="4"><xsl:value-of select="@style"/></td>
                                                </tr>
                                                <tr>
                                                    <th colspan="2"/>
                                                    <th align="right" class="underline" lang="en">Staničení</th>
                                                    <th align="right" class="underline" lang="en">Výška</th>
                                                    <th align="right" class="underline" lang="en">Y<sub>s-jtsk</sub></th>
                                                    <th align="right" class="underline" lang="en">X<sub>s-jtsk</sub></th>
                                                </tr>
                                                <xsl:apply-templates/>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="VerticalLine">
        <tr>
            <td align="left" colspan="6" lang="en"><br/>Prvek: Přímá</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@northing))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@northing))"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="VerticalSymmetricalParabola">
        <tr>
            <td align="left" colspan="6" lang="en"><br/>Prvek: Symetrická parabola</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@northing))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVI/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PVI/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PVI/@northing))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@northing))"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="VerticalUnsymmetricalParabola">
        <tr>
            <td align="left" colspan="6" lang="en"><br/>Pvek: Nesymetrická parabola</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@northing))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVI/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
            </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(-1*number(PVI/@easting))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(-1*number(PVI/@northing))"/>
          </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVCC/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVCC/station/@externalStation), string(PVCC/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVCC/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PVCC/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PVCC/@northing))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@easting))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@northing))"/>
          </td>
        </tr>
    </xsl:template>

    <xsl:template match="VerticalCircle">
        <tr>
            <td align="left" colspan="6" lang="en"><br/>Prvek: Kruhový</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@northing))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVI/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
            </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(-1*number(PVI/@easting))"/>
          </td>
          <td align="right">
            <xsl:value-of select="cif:ordinateFormat(-1*number(PVI/@northing))"/>
          </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalCenter/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalCenter/station/@externalStation), string(VerticalCenter/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalCenter/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalCenter/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalCenter/@northing))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@northing))"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="VerticalClothoid">
        <tr>
            <td align="left" colspan="6" lang="en"><br/>Prvek: Klotoida</td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalStart/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalStart/station/@externalStation), string(VerticalStart/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalStart/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalStart/@northing))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(PVI/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(PVI/station/@externalStation), string(PVI/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(PVI/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PVI/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(PVI/@northing))"/>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="cif:pointType(string(VerticalEnd/@pointType))"/></td>
            <td align="right">
                <xsl:value-of select="cif:stationFormat(number(VerticalEnd/station/@externalStation), string(VerticalEnd/station/@externalStationName))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(number(VerticalEnd/@elevation))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@easting))"/>
            </td>
            <td align="right">
                <xsl:value-of select="cif:ordinateFormat(-1*number(VerticalEnd/@northing))"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jeden Civl prvek výškové geometrie.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
